/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.conndata;

import com.ibm.hwmca.base.rsf.requests.PhoneListRequestProcessor;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.conndata.AccountInfo;
import com.ibm.hwmca.fw.rcs.conndata.AccountingInfo;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoData;
import com.ibm.hwmca.fw.rcs.conndata.ConnectivityInfo;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableCountry;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableSubdivision;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.conndata.RetainUpdatableFile;
import com.ibm.hwmca.fw.rcs.conndata.ServerInfo;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ConnectionInfoManager {
    private static final String TRACE_MASKT = "XRCSCIMT";
    private static final String TRACE_MASKF = "XRCSCIMF";
    private static final String TRACE_MASKD = "XRCSCIMD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-ConnIMgr");
    private static final String RES_REGIONS = "com.ibm.hwmca.fw.rcs.conndata.res.ConnDataRegions";
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoData";
    private static ConnectionInfoManager connectionInfoMgr = null;
    private ConnectionInfoData connInfoData = new ConnectionInfoData();
    private Object dataLock = new Object();
    private static final int REFRESH_INTERVAL = 7;
    private List retainUpdatableFiles = new ArrayList();
    private RetainUpdatableFile attPhoneFile;
    private RetainUpdatableFile retainTcpFile;
    private RetainUpdatableFile piSeriesAcctFile;
    private RetainUpdatableFile storageAcctFile;
    private RetainUpdatableFile zSeriesAcctFile;
    private static final String VPN_BOULDER = "207.25.252.196";
    private static final String VPN_ROCHESTER = "129.42.160.16";
    private static final String SA_BOULDER = "207.25.252.200";
    private static final String SA_ROCHESTER = "129.42.160.48";
    private static final String RS3_BOULDER = "198.74.67.235";
    private static final String RS3_ROCHESTER = "198.74.71.235";
    public static final String ISP_ATT = "ATT";
    public static final int SDC_PRIMARY = 1;
    public static final int SDC_SECONDARY = 2;

    private ConnectionInfoManager() {
        this.init();
        Trace.trace(TRACE_MASKT, "<> ConnectionInfoManager()");
    }

    public static synchronized ConnectionInfoManager getConnectionInfoManager() {
        Trace.trace(TRACE_MASKT, "-> getConnectionInfoManager()");
        if (connectionInfoMgr == null) {
            connectionInfoMgr = new ConnectionInfoManager();
        }
        Trace.trace(TRACE_MASKT, "<- getConnectionInfoManager()");
        return connectionInfoMgr;
    }

    private void init() {
        Trace.trace(TRACE_MASKT, "-> init()");
        PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
        if (persMgr.contains(PERSISTENCE_NAME)) {
            try {
                this.connInfoData = (ConnectionInfoData)persMgr.read(PERSISTENCE_NAME);
            }
            catch (PersistenceException pe) {
                new FrameworkLog(classLogInfo, 1938, pe).log();
                this.connInfoData = new ConnectionInfoData();
            }
        } else {
            this.connInfoData = new ConnectionInfoData();
        }
        try {
            String dataFilePath = BaseFileControl.getFilePath("rcsconndata");
            Trace.trace(TRACE_MASKF, "dataFilePath=" + dataFilePath);
            File attFile = new File(dataFilePath + "actzpho.trm");
            File stagedAttFile = new File(dataFilePath + "ACTZPHO.DAT");
            this.attPhoneFile = new RetainUpdatableFile(attFile, stagedAttFile, "ACTZPHO.DAT", 72);
            this.retainUpdatableFiles.add(this.attPhoneFile);
            File retTcpFile = new File(dataFilePath + "actzprxy.trm");
            File stagedRetTcpFile = new File(dataFilePath + "ACTZPRXY.DAT");
            this.retainTcpFile = new RetainUpdatableFile(retTcpFile, stagedRetTcpFile, "ACTZPRXY.DAT", 130);
            this.retainUpdatableFiles.add(this.retainTcpFile);
            File piAcctFile = new File(dataFilePath + "actzigrp.trm");
            File stagedPiAcctFile = new File(dataFilePath + "ACTZIGRP.DAT");
            this.piSeriesAcctFile = new RetainUpdatableFile(piAcctFile, stagedPiAcctFile, "ACTZIGRP.DAT", 72);
            this.retainUpdatableFiles.add(this.piSeriesAcctFile);
            File storAcctFile = new File(dataFilePath + "actzsgrp.trm");
            File stagedStorAcctFile = new File(dataFilePath + "ACTZSGRP.DAT");
            this.storageAcctFile = new RetainUpdatableFile(storAcctFile, stagedStorAcctFile, "ACTZSGRP.DAT", 72);
            this.retainUpdatableFiles.add(this.storageAcctFile);
            File zAcctFile = new File(dataFilePath + "actzzgrp.trm");
            File stagedZAcctFile = new File(dataFilePath + "ACTZZGRP.DAT");
            this.zSeriesAcctFile = new RetainUpdatableFile(zAcctFile, stagedZAcctFile, "ACTZZGRP.DAT", 72);
            this.retainUpdatableFiles.add(this.zSeriesAcctFile);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public List getDisplayableCountries(Locale locale) {
        Trace.trace(TRACE_MASKT, "-> getDisplayableCountries(" + locale + ")");
        ArrayList<String> countries = new ArrayList<String>();
        HashMap<String, DisplayableCountry> countryData = new HashMap<String, DisplayableCountry>();
        try {
            ResourceBundle regions = ResourceBundle.getBundle(RES_REGIONS, locale);
            Enumeration<String> keys = regions.getKeys();
            while (keys.hasMoreElements()) {
                String isoCode = keys.nextElement();
                if (isoCode.length() != 2) continue;
                String desc = regions.getString(isoCode).trim();
                DisplayableCountry country = new DisplayableCountry(isoCode, desc);
                countryData.put(desc, country);
                countries.add(desc);
            }
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "MissingResourceException: " + mre.getMessage());
            new FrameworkLog(classLogInfo, 1936, mre).log();
        }
        Trace.trace(TRACE_MASKF, "Found " + countries.size() + " countries");
        Collator collator = Collator.getInstance(locale);
        Collections.sort(countries, collator);
        for (int i = 0; i < countries.size(); ++i) {
            String desc = (String)countries.get(i);
            countries.set(i, (String)countryData.get(desc));
        }
        Trace.trace(TRACE_MASKT, "<- getDisplayableCountries()");
        return countries;
    }

    public Map getDisplayableSubdivisions(Locale locale) {
        Trace.trace(TRACE_MASKT, "-> getDisplayableSubdivisions(" + locale + ")");
        HashMap subdivisions = new HashMap();
        try {
            ResourceBundle regions = ResourceBundle.getBundle(RES_REGIONS, locale);
            Enumeration<String> keys = regions.getKeys();
            while (keys.hasMoreElements()) {
                List<DisplayableSubdivision> subdivs;
                String isoCode = keys.nextElement();
                if (isoCode.length() < 4) continue;
                String desc = regions.getString(isoCode).trim();
                String isoCountryCode = isoCode.substring(0, 2);
                String isoSubdivCode = isoCode.substring(3);
                DisplayableSubdivision subdiv = new DisplayableSubdivision(isoSubdivCode, desc);
                if (subdivisions.containsKey(isoCountryCode)) {
                    subdivs = (List)subdivisions.get(isoCountryCode);
                    subdivs.add(subdiv);
                    continue;
                }
                subdivs = new ArrayList();
                subdivs.add(subdiv);
                subdivisions.put(isoCountryCode, subdivs);
            }
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "MissingResourceException: " + mre.getMessage());
            new FrameworkLog(classLogInfo, 1936, mre).log();
        }
        int found = subdivisions.size();
        Trace.trace(TRACE_MASKF, "Found " + found + " countries with subdivisions");
        if (found > 0) {
            Collator collator = Collator.getInstance(locale);
            Set keys = subdivisions.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                int i;
                String key = (String)iterator.next();
                List subdivs = (List)subdivisions.get(key);
                Trace.trace(TRACE_MASKF, "Found " + subdivs.size() + " subdivisions for " + key);
                HashMap<String, DisplayableSubdivision> subdivData = new HashMap<String, DisplayableSubdivision>();
                for (i = 0; i < subdivs.size(); ++i) {
                    DisplayableSubdivision subdiv = (DisplayableSubdivision)subdivs.get(i);
                    String desc = subdiv.getDescription();
                    subdivData.put(desc, subdiv);
                    subdivs.set(i, desc);
                }
                Collections.sort(subdivs, collator);
                for (i = 0; i < subdivs.size(); ++i) {
                    String desc = (String)subdivs.get(i);
                    subdivs.set(i, subdivData.get(desc));
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- getDisplayableSubdivisions()");
        return subdivisions;
    }

    public boolean isValidCountryCode(String isoCtryCode) {
        Trace.trace(TRACE_MASKT, "-> isValidCountryCode(" + isoCtryCode + ")");
        boolean valid = false;
        try {
            ResourceBundle regions = ResourceBundle.getBundle(RES_REGIONS);
            Enumeration<String> keys = regions.getKeys();
            while (keys.hasMoreElements()) {
                String isoCountryCode;
                String isoCode = keys.nextElement();
                if (isoCode.length() != 2 || !isoCtryCode.equals(isoCountryCode = isoCode.substring(0, 2))) continue;
                valid = true;
                break;
            }
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "MissingResourceException: " + mre.getMessage());
            new FrameworkLog(classLogInfo, 1936, mre).log();
        }
        Trace.trace(TRACE_MASKT, "<- isValidCountryCode() " + valid);
        return valid;
    }

    public boolean isValidSubdivisionCode(String isoCtryCode, String isoSubdivCode) {
        Trace.trace(TRACE_MASKT, "-> isValidSubdivisionCode(" + isoCtryCode + ", " + isoSubdivCode + ")");
        boolean valid = false;
        try {
            ResourceBundle regions = ResourceBundle.getBundle(RES_REGIONS);
            Enumeration<String> keys = regions.getKeys();
            while (keys.hasMoreElements()) {
                String isoSubdivisionCode;
                String isoCountryCode;
                String isoCode = keys.nextElement();
                if (isoCode.length() < 4 || !isoCtryCode.equals(isoCountryCode = isoCode.substring(0, 2)) || !isoSubdivCode.equals(isoSubdivisionCode = isoCode.substring(3))) continue;
                valid = true;
                break;
            }
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "MissingResourceException: " + mre.getMessage());
            new FrameworkLog(classLogInfo, 1936, mre).log();
        }
        Trace.trace(TRACE_MASKT, "<- isValidSubdivisionCode() " + valid);
        return valid;
    }

    public boolean isSubdivided(String isoCtryCode) {
        Trace.trace(TRACE_MASKT, "-> isSubdivided(" + isoCtryCode + ")");
        boolean subdivided = false;
        try {
            ResourceBundle regions = ResourceBundle.getBundle(RES_REGIONS);
            Enumeration<String> keys = regions.getKeys();
            while (keys.hasMoreElements()) {
                String isoCountryCode;
                String isoCode = keys.nextElement();
                if (isoCode.length() < 4 || !isoCtryCode.equals(isoCountryCode = isoCode.substring(0, 2))) continue;
                subdivided = true;
                break;
            }
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "MissingResourceException: " + mre.getMessage());
            new FrameworkLog(classLogInfo, 1936, mre).log();
        }
        Trace.trace(TRACE_MASKT, "<- isSubdivided() " + subdivided);
        return subdivided;
    }

    public List getPhoneInfo(String ispId, String isoCtryCode, String isoSubdivCode) {
        Trace.trace(TRACE_MASKT, "-> getPhoneInfo(" + ispId + ", " + isoCtryCode + ", " + isoSubdivCode + ")");
        if (ispId == null) {
            throw new IllegalArgumentException("Null ISP identifier specified");
        }
        if (isoCtryCode == null) {
            throw new IllegalArgumentException("Null ISO country code specified");
        }
        if (isoSubdivCode == null) {
            throw new IllegalArgumentException("Null ISO subdivision code specified");
        }
        ArrayList<PhoneInfo> phoneInfo = new ArrayList<PhoneInfo>();
        try {
            ArrayList rawPhoneData;
            if (this.attPhoneFile != null) {
                rawPhoneData = this.attPhoneFile.getData();
            } else {
                Trace.trace(TRACE_MASKF, "ISP phone data file undefined");
                rawPhoneData = new ArrayList();
            }
            boolean ISO_COUNTRY_START = true;
            int ISO_COUNTRY_END = 2;
            int ISO_REGION_START = 4;
            int ISO_REGION_END = 5;
            int LOCATION_START = 7;
            int LOCATION_END = 26;
            int NUMBER_START = 28;
            int NUMBER_END = 59;
            ArrayList<PhoneInfo> multiRegionInfo = new ArrayList<PhoneInfo>();
            boolean countrySubdivided = this.isSubdivided(isoCtryCode);
            for (int i = 0; i < rawPhoneData.size(); ++i) {
                PhoneInfo info;
                String data = (String)rawPhoneData.get(i);
                String cCode = data.substring(0, 2).trim();
                String sCode = data.substring(3, 5).trim();
                if (!cCode.equals(isoCtryCode)) continue;
                String desc = data.substring(6, 26).trim();
                String number = data.substring(27, 59).trim();
                if (countrySubdivided) {
                    if (sCode.equals("")) {
                        info = new PhoneInfo(number, desc, cCode, "", number);
                        info.setMultiSubdivision(true);
                        multiRegionInfo.add(info);
                        continue;
                    }
                    if (!sCode.equals(isoSubdivCode)) continue;
                    info = new PhoneInfo(number, desc, cCode, sCode, number);
                    phoneInfo.add(info);
                    continue;
                }
                if (!sCode.equals(isoSubdivCode)) continue;
                info = new PhoneInfo(number, desc, cCode, sCode, number);
                phoneInfo.add(info);
            }
            Collections.sort(phoneInfo);
            Collections.sort(multiRegionInfo);
            phoneInfo.addAll(multiRegionInfo);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- getPhoneInfo() " + phoneInfo.size());
        return phoneInfo;
    }

    public AccountingInfo getAccountingInfo(PathPlatform platform, String isoCtryCode, String isoSubdivCode) {
        Trace.trace(TRACE_MASKT, "-> getAccountingInfo(" + platform + ", " + isoCtryCode + ", " + isoSubdivCode + ")");
        if (isoCtryCode == null) {
            throw new IllegalArgumentException("Null ISO country code specified");
        }
        if (isoSubdivCode == null) {
            throw new IllegalArgumentException("Null ISO subdivision code specified");
        }
        AccountingInfo accountingInfo = new AccountingInfo();
        try {
            ArrayList rawAcctData;
            RetainUpdatableFile acctFile = null;
            if (platform == PathPlatform.PISERIES) {
                acctFile = this.piSeriesAcctFile;
            } else if (platform == PathPlatform.STORAGE) {
                acctFile = this.storageAcctFile;
            } else if (platform == PathPlatform.ZSERIES) {
                acctFile = this.zSeriesAcctFile;
            } else if (platform == PathPlatform.GENERIC) {
                acctFile = this.zSeriesAcctFile;
            } else {
                Trace.trace(TRACE_MASKF, "Unsupported path platform: " + platform);
                acctFile = this.zSeriesAcctFile;
            }
            if (acctFile != null) {
                rawAcctData = acctFile.getData();
            } else {
                Trace.trace(TRACE_MASKF, "Account data file undefined");
                rawAcctData = new ArrayList();
            }
            boolean ISO_COUNTRY_START = true;
            int ISO_COUNTRY_END = 2;
            int ACCOUNT_START = 4;
            int ACCOUNT_END = 11;
            int USERID_START = 13;
            int USERID_END = 20;
            int PASSWORD_START = 22;
            int PASSWORD_END = 29;
            for (int i = 0; i < rawAcctData.size(); ++i) {
                String data = (String)rawAcctData.get(i);
                String cCode = data.substring(0, 2).trim();
                if (!cCode.equals(isoCtryCode)) continue;
                String account = data.substring(3, 11).trim();
                String userId = data.substring(12, 20).trim();
                String pw = data.substring(21, 29).trim();
                AccountInfo ursf = new AccountInfo(account, userId, pw, cCode, "");
                accountingInfo.addAccountInfo("Account_URSF", ursf);
                break;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- getAccountingInfo()");
        return accountingInfo;
    }

    public ConnectivityInfo getConnectivityInfo(String isoCtryCode, String isoSubdivCode) {
        Trace.trace(TRACE_MASKT, "-> getConnectivityInfo(" + isoCtryCode + ", " + isoSubdivCode + ")");
        int sdc = 1;
        try {
            int rcsSdc = PathManager.getPathManager().getSdc();
            if (rcsSdc == 2) {
                sdc = 2;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e.getClass().getName() + ": " + e.getMessage());
            Trace.trace(TRACE_MASKF, "Defaulting to primary SDC");
        }
        ConnectivityInfo connInfo = this.getConnectivityInfo(isoCtryCode, isoSubdivCode, sdc);
        Trace.trace(TRACE_MASKT, "<- getConnectivityInfo()");
        return connInfo;
    }

    public ConnectivityInfo getConnectivityInfo(String isoCtryCode, String isoSubdivCode, int sdc) {
        Trace.trace(TRACE_MASKT, "-> getConnectivityInfo(" + isoCtryCode + ", " + isoSubdivCode + ", " + sdc + ")");
        if (isoCtryCode == null) {
            throw new IllegalArgumentException("Null ISO country code specified");
        }
        if (isoSubdivCode == null) {
            throw new IllegalArgumentException("Null ISO subdivision code specified");
        }
        if (!this.isValidSdc(sdc)) {
            throw new IllegalArgumentException("Invalid SDC specified");
        }
        ConnectivityInfo connectivityInfo = new ConnectivityInfo();
        try {
            ArrayList rawConnData;
            if (this.retainTcpFile != null) {
                rawConnData = this.retainTcpFile.getData();
            } else {
                Trace.trace(TRACE_MASKF, "RETAIN data file undefined");
                rawConnData = new ArrayList();
            }
            boolean ISO_COUNTRY_START = true;
            int ISO_COUNTRY_END = 2;
            int ISO_REGION_START = 4;
            int ISO_REGION_END = 5;
            int BUSINESS_UNIT_START = 7;
            int BUSINESS_UNIT_END = 9;
            int AREA_NAME_START = 11;
            int AREA_NAME_END = 30;
            int PRIMARY_VPN_START = 32;
            int PRIMARY_VPN_END = 47;
            int PRIMARY_URSF_START = 49;
            int PRIMARY_URSF_END = 64;
            int PRIMARY_URSF_PORT_START = 66;
            int PRIMARY_URSF_PORT_END = 70;
            int SECONDARY_VPN_START = 72;
            int SECONDARY_VPN_END = 87;
            int SECONDARY_URSF_START = 89;
            int SECONDARY_URSF_END = 104;
            int SECONDARY_URSF_PORT_START = 106;
            int SECONDARY_URSF_PORT_END = 110;
            ServerInfo vpnServer = null;
            ServerInfo ursfServer = null;
            ServerInfo saServer = null;
            ServerInfo sasServer = null;
            ServerInfo rs3Server = null;
            for (int i = 0; i < rawConnData.size(); ++i) {
                String data = (String)rawConnData.get(i);
                String cCode = data.substring(0, 2).trim();
                String sCode = data.substring(3, 5).trim();
                if (!cCode.equals(isoCtryCode) || !sCode.equals(isoSubdivCode)) continue;
                String ipAddr = "";
                String sPort = "";
                int port = 0;
                ipAddr = sdc == 1 ? data.substring(31, 47).trim() : data.substring(71, 87).trim();
                vpnServer = new ServerInfo(ipAddr, port, cCode, sCode);
                connectivityInfo.addServerInfo("Server_VPN", vpnServer);
                if (sdc == 1) {
                    ipAddr = data.substring(48, 64).trim();
                    sPort = data.substring(65, 70).trim();
                } else {
                    ipAddr = data.substring(88, 104).trim();
                    sPort = data.substring(105, 110).trim();
                }
                try {
                    port = Integer.parseInt(sPort);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Invalid port " + sPort + " for " + cCode + sCode);
                    port = 0;
                }
                ursfServer = new ServerInfo(ipAddr, port, cCode, sCode);
                connectivityInfo.addServerInfo("Server_URSF", ursfServer);
                break;
            }
            if (vpnServer != null) {
                if (vpnServer.getIpAddress().equals(VPN_BOULDER)) {
                    saServer = new ServerInfo(SA_BOULDER, 443, isoCtryCode, isoSubdivCode);
                    connectivityInfo.addServerInfo("Server_SA", saServer);
                    sasServer = new ServerInfo(SA_BOULDER, 443, isoCtryCode, isoSubdivCode);
                    connectivityInfo.addServerInfo("Server_SAS", saServer);
                    rs3Server = new ServerInfo(RS3_BOULDER, 11111, isoCtryCode, isoSubdivCode);
                    connectivityInfo.addServerInfo("Server_RS3", rs3Server);
                } else {
                    saServer = new ServerInfo(SA_ROCHESTER, 443, isoCtryCode, isoSubdivCode);
                    connectivityInfo.addServerInfo("Server_SA", saServer);
                    sasServer = new ServerInfo(SA_ROCHESTER, 443, isoCtryCode, isoSubdivCode);
                    connectivityInfo.addServerInfo("Server_SAS", saServer);
                    rs3Server = new ServerInfo(RS3_ROCHESTER, 11111, isoCtryCode, isoSubdivCode);
                    connectivityInfo.addServerInfo("Server_RS3", rs3Server);
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- getConnectivityInfo()");
        return connectivityInfo;
    }

    private boolean isValidSdc(int sdc) {
        switch (sdc) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public String getBusinessUnit(String isoCtryCode, String isoSubdivCode) {
        Trace.trace(TRACE_MASKT, "-> getBusinessUnit(" + isoCtryCode + ", " + isoSubdivCode + ")");
        if (isoCtryCode == null) {
            throw new IllegalArgumentException("Null ISO country code specified");
        }
        if (isoSubdivCode == null) {
            throw new IllegalArgumentException("Null ISO subdivision code specified");
        }
        String businessUnit = "";
        try {
            ArrayList rawConnData;
            if (this.retainTcpFile != null) {
                rawConnData = this.retainTcpFile.getData();
            } else {
                Trace.trace(TRACE_MASKF, "RETAIN data file undefined");
                rawConnData = new ArrayList();
            }
            boolean ISO_COUNTRY_START = true;
            int ISO_COUNTRY_END = 2;
            int ISO_REGION_START = 4;
            int ISO_REGION_END = 5;
            int BUSINESS_UNIT_START = 7;
            int BUSINESS_UNIT_END = 9;
            for (int i = 0; i < rawConnData.size(); ++i) {
                String data = (String)rawConnData.get(i);
                String cCode = data.substring(0, 2).trim();
                String sCode = data.substring(3, 5).trim();
                if (!cCode.equals(isoCtryCode) || !sCode.equals(isoSubdivCode)) continue;
                businessUnit = data.substring(6, 9).trim();
                break;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- getBusinessUnit() " + businessUnit);
        return businessUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUpdatableFiles(boolean force) {
        Trace.trace(TRACE_MASKT, "-> refreshUpdatableFiles(" + force + ")");
        Date now = new Date();
        boolean getRefresh = false;
        Object object = this.dataLock;
        synchronized (object) {
            Date nextRefresh = this.connInfoData.getNextRefresh();
            if (force || now.compareTo(nextRefresh) > 0) {
                Trace.trace(TRACE_MASKF, "Refresh needed now");
                getRefresh = true;
                nextRefresh.setTime(now.getTime() + 604800000L);
                this.connInfoData.setNextRefresh(nextRefresh);
                try {
                    PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, this.connInfoData);
                }
                catch (PersistenceException pe) {
                    new FrameworkLog(classLogInfo, 1938, pe).log();
                }
            }
            Trace.trace(TRACE_MASKF, "Next refresh " + nextRefresh);
        }
        if (getRefresh) {
            PhoneListRequestProcessor.getRetainPhoneList(this.retainUpdatableFiles);
        }
        Trace.trace(TRACE_MASKT, "<- refreshUpdatableFiles()");
    }
}

